<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="robots" content="noindex, nofollow">

		<title>Samsung AI Memory</title>

		<link rel="apple-touch-icon" sizes="180x180" href="/si/assets/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="/si/assets/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="/si/assets/favicon-16x16.png">
		<link rel="manifest" href="/si/assets/site.webmanifest">

		<link rel="stylesheet" href="/si/assets/style/style.css" type="text/css">
	</head>
	<body>
		<div class="signup">
			<div class="signup-content">
				<img src="/si/assets/logo.svg" class="signup-logo">

				<h1>Igra Memory</h1>
				<p class="signup-description">Igrajte našo igro Memory in preizkusite svojo hitrost, saj boste morda prav vi eden izmed naših zmagovalcev.</p>

				<form name="prijava" method="POST" action="/">
					<input type="text" name="imeprezime" placeholder="Ime in priimek" class="imeprezime" autocomplete="off">
					<input type="email" name="email" placeholder="Email naslov" class="email" autocomplete="off">
					<input type="tel" name="telefon" placeholder="Kontaktna številka" class="telefon" autocomplete="off">

					<label class="checkbox">Sprejemam <a href="/si/SI_Nagradni natjecaj_Galaxy AI Kiosk Slovenija SAMSUNG 31.01.2025.docx">pogoje in pravila uporabe</a>.
						<input type="checkbox" class="uvjetikoristenja">
						<span class="checkmark"></span>
					</label>

					<button>Igraj igro</button>

					<div class="error hidden">
						<p></p>
					</div>
				</form>
			</div>
		</div>
		<div class="game hidden">
			<div class="game-content">
				<div class="game-header">
					<img src="/si/assets/logo.svg" class="game-logo">
					<div class="game-timer">
						<p>Vaš rezultat</p>
						<p class="game-currentTime">0:00</p>
					</div>
				</div>
				<div class="game-cards">

				</div>
			</div>
		</div>
		<div class="leaderboards hidden">
			<img src="/si/assets/logo.svg" class="leaderboards-logo">

			<p class="leaderboards-currentScore text-center">Vaš trenutni rezultat: <span></span></p>
			<p class="leaderboards-currentPosition text-center">Trenutno se nahajate na <span></span>. mestu</p>
			<p class="text-center">Igrajte znova jutri</p>

			<h2>Trenutni krog</h2>
			<div class="leaderboards-content">

			</div>
		</div>

		<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
		<script src="/si/assets/js/required.js"></script>
	</body>
</html>
