<?php

class IndexModel extends CI_Model {
	
	public function __construct () {
		parent::__construct();
	}

	public function getTrenutniKrug($withPrevious = false) {
        $this->db->select('*')
				 ->from('krugovi');

		$query = $this->db->get();
		$krugovi = $query->result_array();
		
		$trenutniKrug = null;
		$currentDate = strtotime(date('Y-m-d'));
		
		foreach($krugovi AS $krug) {
			if(strtotime($krug['start_date']) <= $currentDate && strtotime($krug['end_date']) >= $currentDate) {
				$trenutniKrug = $krug['id'];
			}
		}
		
		if(!$trenutniKrug && $withPrevious) {
		    foreach($krugovi AS $krug) {
    			if(strtotime($krug['end_date']) < $currentDate) {
				    $trenutniKrug = $krug['id'] + 1;
			    }
    		}
		}
		
		return $trenutniKrug;
	}

	public function insertParticipant($imeprezime, $email, $telefon, $vrijeme) {
        $krug_id = 0;

        $this->db->select('*')
				 ->from('krugovi');

		$query = $this->db->get();
		$krugovi = $query->result_array();
		
		foreach($krugovi AS $krug) {
            $currentDate = strtotime(date('Y-m-d'));

			if(strtotime($krug['start_date']) <= $currentDate && strtotime($krug['end_date']) >= $currentDate) {
				$krug_id = $krug['id'];
			}
		}

		$insert_id = 0;

		if($krug_id !== 0) {
			$data = [
				'krug_id' => $krug_id,
				'imeprezime' => $imeprezime,
				'email' => $email,
				'telefon' => $telefon,
				'vrijeme' => $vrijeme,
			];

			$this->db->insert('natjecatelji', $data);
			$insert_id = $this->db->insert_id();
		}

		$this->db->select('id')
				 ->from('natjecatelji')
				 ->where('krug_id', $krug_id)
				 ->order_by('vrijeme', 'ASC');
		$query = $this->db->get();
		$entries = $query->result_array();

		$position = 1;
		foreach($entries AS $entry) {
			if($insert_id == $entry['id']) {
				return $position;
			}

			$position++;
		}
	}

    public function canParticipate($email) {
		$this->db->select('vrijeme_prijave')
				 ->from('natjecatelji')
				 ->where('email', $email);

		$query = $this->db->get();
		$entries = $query->result_array();
		
		foreach($entries AS $entry) {
            $currentDate = strtotime(date('Y-m-d'));
			$entryDate = strtotime(date('Y-m-d', strtotime($entry['vrijeme_prijave'])));

			if($entryDate == $currentDate) {
				return false;
			}
		}
		
		return true;
	}

	public function fetchEntries() {
		$this->db->select('MIN(vrijeme) as vrijeme, imeprezime')
				 ->from('natjecatelji')
				 ->where('krug_id', 1)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(10);

		$query = $this->db->get();
		$entries1 = $query->result_array();

		$this->db->select('MIN(vrijeme) as vrijeme, imeprezime')
				 ->from('natjecatelji')
				 ->where('krug_id', 2)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(10);

		$query = $this->db->get();
		$entries2 = $query->result_array();

		$this->db->select('MIN(vrijeme) as vrijeme, imeprezime')
				 ->from('natjecatelji')
				 ->where('krug_id', 3)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(10);

		$query = $this->db->get();
		$entries3 = $query->result_array();

		$this->db->select('MIN(vrijeme) as vrijeme, imeprezime')
				 ->from('natjecatelji')
				 ->where('krug_id', 4)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(10);

		$query = $this->db->get();
		$entries4 = $query->result_array();

		$this->db->select('MIN(vrijeme) as vrijeme, imeprezime')
				 ->from('natjecatelji')
				 ->where('krug_id', 5)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(10);

		$query = $this->db->get();
		$entries5 = $query->result_array();

		$this->db->select('MIN(vrijeme) as vrijeme, imeprezime')
				 ->from('natjecatelji')
				 ->where('krug_id', 6)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(10);

		$query = $this->db->get();
		$entries6 = $query->result_array();
		
		return array(
			1 => $entries1,
			2 => $entries2,
			3 => $entries3,
			4 => $entries4,
			5 => $entries5,
			6 => $entries6,
		);
	}
	
	public function fetchStats() {
		$this->db->select('COUNT(id) as count')
				 ->from('natjecatelji')
				 ->where('krug_id', 1);
		$entries1['all'] = $this->db->get()->row()->count;
		$entries1['unique'] = $this->db->query('SELECT COUNT(id) as count FROM (SELECT * FROM natjecatelji WHERE krug_id = 1 GROUP BY email) as t;')->row()->count;
		$this->db->select('imeprezime, email, telefon, MIN(vrijeme) as vrijeme, ')
				 ->from('natjecatelji')
				 ->where('krug_id', 1)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(20);
		$entries1['results'] = $this->db->get()->result_array();

		$this->db->select('COUNT(id) as count')
				 ->from('natjecatelji')
				 ->where('krug_id', 2);
		$entries2['all'] = $this->db->get()->row()->count;
		$entries2['unique'] = $this->db->query('SELECT COUNT(id) as count FROM (SELECT * FROM natjecatelji WHERE krug_id = 2 GROUP BY email) as t;')->row()->count;
		$this->db->select('imeprezime, email, telefon, MIN(vrijeme) as vrijeme, ')
				 ->from('natjecatelji')
				 ->where('krug_id', 2)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(20);
		$entries2['results'] = $this->db->get()->result_array();
		
		$this->db->select('COUNT(id) as count')
				 ->from('natjecatelji')
				 ->where('krug_id', 3);
		$entries3['all'] = $this->db->get()->row()->count;
		$entries3['unique'] = $this->db->query('SELECT COUNT(id) as count FROM (SELECT * FROM natjecatelji WHERE krug_id = 3 GROUP BY email) as t;')->row()->count;
	    $this->db->select('imeprezime, email, telefon, MIN(vrijeme) as vrijeme, ')
				 ->from('natjecatelji')
				 ->where('krug_id', 3)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(20);
		$entries3['results'] = $this->db->get()->result_array();
		
		$this->db->select('COUNT(id) as count')
				 ->from('natjecatelji')
				 ->where('krug_id', 4);
		$entries4['all'] = $this->db->get()->row()->count;
		$entries4['unique'] = $this->db->query('SELECT COUNT(id) as count FROM (SELECT * FROM natjecatelji WHERE krug_id = 4 GROUP BY email) as t;')->row()->count;
		$this->db->select('imeprezime, email, telefon, MIN(vrijeme) as vrijeme, ')
				 ->from('natjecatelji')
				 ->where('krug_id', 4)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(20);
		$entries4['results'] = $this->db->get()->result_array();
		
		$this->db->select('COUNT(id) as count')
				 ->from('natjecatelji')
				 ->where('krug_id', 5);
		$entries5['all'] = $this->db->get()->row()->count;
		$entries5['unique'] = $this->db->query('SELECT COUNT(id) as count FROM (SELECT * FROM natjecatelji WHERE krug_id = 5 GROUP BY email) as t;')->row()->count;
		$this->db->select('imeprezime, email, telefon, MIN(vrijeme) as vrijeme, ')
				 ->from('natjecatelji')
				 ->where('krug_id', 5)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(20);
		$entries5['results'] = $this->db->get()->result_array();
		
		$this->db->select('COUNT(id) as count')
				 ->from('natjecatelji')
				 ->where('krug_id', 6);
		$entries6['all'] = $this->db->get()->row()->count;
		$entries6['unique'] = $this->db->query('SELECT COUNT(id) as count FROM (SELECT * FROM natjecatelji WHERE krug_id = 6 GROUP BY email) as t;')->row()->count;
		$this->db->select('imeprezime, email, telefon, MIN(vrijeme) as vrijeme, ')
				 ->from('natjecatelji')
				 ->where('krug_id', 6)
				 ->group_by('email')
				 ->order_by('vrijeme', 'ASC')
				 ->limit(20);
		$entries6['results'] = $this->db->get()->result_array();
		
		return array(
			1 => $entries1,
			2 => $entries2,
			3 => $entries3,
			4 => $entries4,
			5 => $entries5,
			6 => $entries6,
		);
	}
}

?>