$(window).on("load", function () {
  var startTime, timeout, interval;
  var matches = 0;

  $(".signup form input").keypress(function () {
    $(this).removeClass("hasError");
  });

  $(".signup form button").on("click", function (event) {
    event.preventDefault();

    $(".signup form .error").addClass("hidden");
    $(".signup form .error p").html("");

    const imeprezime = $(".imeprezime").val();
    const email = $(".email").val();
    const telefon = $(".telefon").val();

    if (!imeprezime.length || !email.length || !telefon.length) {
      if (!imeprezime.length) {
        $(".imeprezime").addClass("hasError");
        $(".signup form .error").removeClass("hidden");
        $(".signup form .error p").html("Sva polja su obavezna");
      }
      if (!email.length) {
        $(".email").addClass("hasError");
        $(".signup form .error").removeClass("hidden");
        $(".signup form .error p").html("Sva polja su obavezna");
      }
      if (!telefon.length) {
        $(".telefon").addClass("hasError");
        $(".signup form .error").removeClass("hidden");
        $(".signup form .error p").html("Sva polja su obavezna");
      }
    } else if (!isEmail(email)) {
      $(".email").addClass("hasError");
      $(".signup form .error").removeClass("hidden");
      $(".signup form .error p").html("Molimo upišite pravilnu email adresu");
    } else if (!$(".uvjetikoristenja").is(":checked")) {
      $(".signup form .error").removeClass("hidden");
      $(".signup form .error p").html(
        "Prihvaćanje uvjeta i pravila korištenja je obavezno"
      );
    } else {
      $.ajax({
        url: "participants/canParticipate",
        type: "POST",
        data: { email: email },
        success: function (response) {
          response = JSON.parse(response);

          if (response.status == "success") {
            $(".signup").addClass("hidden");
            $(".game").removeClass("hidden");

            timeout = setTimeout(function () {
              startTime = Date.now();

              interval = setInterval(function () {
                var elapsedTime = Date.now() - startTime;
                var currentTime = (elapsedTime / 1000).toFixed(0);

                var minutes = Math.floor(currentTime / 60);
                var seconds = currentTime % 60;

                if (seconds < 10) {
                  seconds = "0" + seconds;
                }

                $(".game-currentTime").html(minutes + ":" + seconds);
              }, 100);
            }, 1000);
          } else {
            $(".email").addClass("hasError");
            $(".signup form .error").removeClass("hidden");
            $(".signup form .error p").html(
              "Danas ste već igrali, zaigrajte sutra opet!"
            );
          }
        },
        error: function (xhr, status, error) {
          console.log(xhr.responseText);
        },
      });
    }
  });

  const gridContainer = document.querySelector(".game-cards");
  let cards = [];
  let firstCard, secondCard;
  let lockBoard = false;

  fetch("/hr/assets/cards.json")
    .then((res) => res.json())
    .then((data) => {
      cards = [...data, ...data];
      shuffleCards();
      generateCards();
    });

  function shuffleCards() {
    let currentIndex = cards.length,
      randomIndex,
      temporaryValue;
    while (currentIndex !== 0) {
      randomIndex = Math.floor(Math.random() * currentIndex);
      currentIndex -= 1;
      temporaryValue = cards[currentIndex];
      cards[currentIndex] = cards[randomIndex];
      cards[randomIndex] = temporaryValue;
    }
  }

  function generateCards() {
    for (let card of cards) {
      const cardElement = document.createElement("div");
      cardElement.classList.add("card");
      cardElement.setAttribute("data-name", card.name);
      cardElement.innerHTML = `
      <div class="front">
        <img class="front-image" src=${card.image} />
      </div>
      <div class="back"></div>
    `;
      gridContainer.appendChild(cardElement);
      cardElement.addEventListener("click", flipCard);
    }
  }

  function flipCard() {
    if (lockBoard) return;
    if (this === firstCard) return;

    this.classList.add("flipped");

    if (!firstCard) {
      firstCard = this;
      return;
    }

    secondCard = this;
    lockBoard = true;

    checkForMatch();
  }

  function checkForMatch() {
    if (firstCard.dataset.name === secondCard.dataset.name) {
      matchCards();
      matches++;

      if (matches === 10) {
        var elapsedTime = Date.now() - startTime;

        var endTime = (elapsedTime / 1000).toFixed(2);
        var minutes = Math.floor(endTime / 60);
        var seconds = (endTime % 60).toFixed(2);

        if (seconds < 10) {
          seconds = "0" + seconds;
        }

        $(".leaderboards-currentScore span").html(minutes + ":" + seconds);

        clearTimeout(timeout);
        clearInterval(interval);

        $.ajax({
          url: "participants/insert",
          type: "POST",
          data: {
            imeprezime: $(".imeprezime").val(),
            email: $(".email").val(),
            telefon: $(".telefon").val(),
            vrijeme: elapsedTime,
          },
          success: function (response) {
            response = JSON.parse(response);

            $(".leaderboards-currentPosition span").html(
              response.currentPosition
            );

            $(".game").addClass("hidden");
            $(".leaderboards").removeClass("hidden");
            restart();

            $.ajax({
              url: "leaderboards/fetch",
              type: "GET",
              success: function (response) {
                response = JSON.parse(response);
                $(".leaderboards-content").html(response.html);
              },
              error: function (xhr, status, error) {
                console.log(xhr.responseText);
              },
            });
          },
          error: function (xhr, status, error) {
            console.log(xhr.responseText);
          },
        });
      }
    } else {
      unflipCards();
    }
  }

  function matchCards() {
    firstCard.classList.add("match");
    secondCard.classList.add("match");
    firstCard.removeEventListener("click", flipCard);
    secondCard.removeEventListener("click", flipCard);

    resetBoard();
  }

  function unflipCards() {
    setTimeout(() => {
      firstCard.classList.remove("flipped");
      secondCard.classList.remove("flipped");
      resetBoard();
    }, 1000);
  }

  function resetBoard() {
    firstCard = null;
    secondCard = null;
    lockBoard = false;
  }

  function restart() {
    resetBoard();
    shuffleCards();
    gridContainer.innerHTML = "";
    generateCards();
  }

  function isEmail(email) {
    var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    return regex.test(email);
  }
});
